package com.luca.pilot.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

/**
 * @author Wong
 * @date 2024/1/6 14:17
 */
@Slf4j
@Configuration
@EnableMongoRepositories(mongoTemplateRef = "mongoArchiveTemplate")
public class MongoArchiveTemplateConfig {

    @Value("${spring.data.archive-mongodb.uri}")
    private String uri;

    @Bean(name = "mongoArchiveTemplate")
    public MongoTemplate mongoECrfTemplate() {
        log.info("-----------------------Backend Init MongoECrfTemplate Success-----------------------------------");
        return new MongoTemplate(mongoECrfFactory());
    }

    @Bean
    public MongoDatabaseFactory mongoECrfFactory() {
        SimpleMongoClientDatabaseFactory simpleMongoClientDbFactory = new SimpleMongoClientDatabaseFactory(uri);
        return simpleMongoClientDbFactory;
    }

}
