package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.time.LocalDate;

/**
 * @author jiangbangfa
 * @date 2021/7/19 下午6:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@Document(collection="project")
public class Project extends AbstractAuditingEntity {


    private Long id;

    private String code;

    private String name;

    @Field("app_ids")
    private String appIds;

    @Field("invite_code")
    private String inviteCode;

    private Long type;

    private String number;

    @Field("tenant_id")
    private Long tenantId;

    @Field("bid_unit")
    private String bidUnit;

    private String version;

//    @Field("start_at")
//    private LocalDate startAt;
//
//    @Field("end_at")
//    private LocalDate endAt;

    private String url;
    @Field("dashboard_show_code")
    private String dashboardShowCode;

    @Field("dashboard_show_name")
    private String dashboardShowName;

    /**
     * 日记使用 方案名称 非必填
     */
    @Field("scheme_name")
    private String schemeName;

    /**
     * 日记使用 方案编号 非必填
     */
    @Field("scheme_code")
    private String schemeCode;

//    /**
//     * 是否认证
//     */
//    @Field("enable_id_verification")
//    private Boolean enableIdVerification;


    /**
     * 0 未锁库 1 已锁库
     */
    private Integer locked;

    /**
     * 研究随访时长
     */
    @Field("study_follow_up_time")
    private Integer studyFollowUpTime;

    /**
     * 计划人数
     */
    @Field("plan_people")
    private Long planPeople;

}
