package com.luca.pilot.entity;


import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.mongodb.core.mapping.Document;

import java.io.Serializable;

/**
 * <p>
 * 科研采集信息表
 * </p>
 *
 * @author linfeng.yang
 * @since 2023-06-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Document("collect_module")
public class CollectModule extends AbstractAuditingEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 租户ID
     */
    private Long tenantId;

    /**
     * 名称
     */
    private String name;

    /**
     * 编码
     */
    private String code;

    /**
     * 采集类型
     */
    private String collectType;

    /**
     * 采集时长
     */
    private Integer collectDuration;

    /**
     * 本地算法
     */
    private String localAlgorithm;

    /**
     * 示例媒体文件URL
     */
    private String mediaUrl;

    /**
     * 示例媒体文件前端使用
     */
    private String audioMinioPath;

    /**
     * 描述
     */
    private String description;

    /**
     * 图片地址
     */
    private String imgUrl;

    /**
     * 是否计时 0或者null 否 1 是
     */
    private String isTime;

    /**
     * 计时时间
     */
    private String time;


}
