package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * <p>
 * 数字靶点子模块详细信息表
 * </p>
 *
 * @since 2022-01-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Document(collection = "digital_medical_details")
public class DigitalMedicalDetails extends AbstractAuditingEntity {

    /**
     * id
     */
    private Long id;

    /**
     * 租户id
     */
    private Long tenantId;

    /**
     * 名称
     */
    private String name;

    /**
     * code
     */
    private String code;

    /**
     * 描述
     */
    private String description;

    /**
     * 算法id
     */
    private Long algorithmId;

    /**
     * 算法名称
     */
    private String algorithmName;

    /**
     * 算法类型
     * com.luca.enumeration.DbmAlgorithmType枚举
     * 对应
     * com.lucahealthcare.luca.common.enumerations.ModuleItemType枚举
     */
    private String algorithmType;

    /**
     * 算法支持设备
     */
    private String algorithmDevices;

    /**
     * 算法详情
     */
    private String algorithmDetails;

    /**
     * 数字诊疗详情下的子数字诊疗id，JSONArray，  todo:冠霖说放到算法下
     */
    private String subAlgorithm;


}
