package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author linfeng.yang
 * @since 2021-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Document("questionnaire_answer_option")
public class QuestionnaireAnswerOption extends AbstractAuditingEntity implements Serializable{

    private static final long serialVersionUID = 1L;

    private Long id;

    @Field("answer_id")
    private Long answerId;

    @Field("option_id")
    private Long optionId;

    @Field("option_name")
    private String optionName;

    @Field("question_id")
    private Long questionId;

    private String content;

    @Field("date_at")
    private String dateAt;

    @Field("number_answer")
    private BigDecimal numberAnswer;

    @Field("left_min")
    private BigDecimal leftMin;

    @Field("right_max")
    private BigDecimal rightMax;

}
