package com.luca.pilot.bizEnum;

import cn.hutool.core.util.ObjectUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Classname CrfQuestionTypeEnum
 * @Description TODO
 * @Date 2023/7/18 10:29
 * @Created by 范宇坤
 */
@Getter
@AllArgsConstructor
public enum CrfQuestionTypeEnum {

    CUSTOMIZE("CUSTOMIZE", "意外类型"),
    TEMPLATE("TEMPLATE", "外层框架"),
    REGULAR("REGULAR", "固定结构"),
    TEXT("TEXT", "输入框"),
    TEXTAREA("TEXTAREA", "多行输入框"),
    NUMBER("NUMBER", "数值"),
    DATE("DATE", "日期选择"),
    SELECT("SELECT", "下拉单选"),
    RADIO("RADIO", "点击单选"),
    MUTISELECT("MUTISELECT", "下拉多选"),
    CRFTABLE("CRFTABLE", "矩阵填空"),
    CASCADER("CASCADER", "级联选择"),
    ;

    private String code;
    private String desc;

    public static CrfQuestionTypeEnum getDeviceEnum(String code) {
        for (CrfQuestionTypeEnum value : CrfQuestionTypeEnum.values()) {
            if (ObjectUtil.equal(value.code, code)) {
                return value;
            }
        }
        return null;
    }
}
