package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

/**
 * @author linfeng.yang
 * @date 2021/8/03 下午14:40
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@Document("patient_scale_evaluating")
public class PatientScaleEvaluatingEntity extends AbstractAuditingEntity {
    private static final long serialVersionUID = 1L;

    private Long id;
    private String code;

    @Field("project_code")
    private String projectCode;
    private String patientCode;
    private String siteId;
    @Field("scale_code")
    private String scaleCode;
    @Field("scale_result")
    private String scaleResult;
    private String ruleId;

    /**
     * 量表答题总得分
     */
    @Field("total_score")
    private String totalScore;

    /**
     * 患者任务详情id
     */
    @Field("plan_task_details_id")
    private Long planTaskDetailsId;
}
