/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticjob;

import java.lang.reflect.Method;
import org.apache.shardingsphere.elasticjob.infra.listener.ShardingContexts;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ElasticJobExecutorInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) {
        ShardingContexts shardingContexts = (ShardingContexts)allArguments[1];
        Integer item = (Integer)allArguments[2];
        String operateName = ComponentsDefine.ELASTIC_JOB.getName() + "/" + shardingContexts.getJobName();
        AbstractSpan span = ContextManager.createLocalSpan((String)operateName);
        span.setComponent((Component)ComponentsDefine.ELASTIC_JOB);
        Tags.LOGIC_ENDPOINT.set(span, "{\"logic-span\":true}");
        span.tag(Tags.ofKey((String)"item"), item == null ? "" : String.valueOf(item));
        span.tag(Tags.ofKey((String)"shardingTotalCount"), Integer.toString(shardingContexts.getShardingTotalCount()));
        span.tag(Tags.ofKey((String)"taskId"), shardingContexts.getTaskId());
        span.tag(Tags.ofKey((String)"shardingItemParameters"), shardingContexts.getShardingItemParameters() == null ? "" : shardingContexts.getShardingItemParameters().toString());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

