/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.activemq;

import java.lang.reflect.Method;
import org.apache.activemq.command.MessageDispatch;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class ActiveMQConsumerInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String OPERATE_NAME_PREFIX = "ActiveMQ/";
    public static final String CONSUMER_OPERATE_NAME_SUFFIX = "/Consumer";
    public static final byte QUEUE_TYPE = 1;
    public static final byte TOPIC_TYPE = 2;
    public static final byte TEMP_TOPIC_TYPE = 6;
    public static final byte TEMP_QUEUE_TYPE = 5;

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ContextCarrier contextCarrier = new ContextCarrier();
        String url = (String)objInst.getSkyWalkingDynamicField();
        MessageDispatch messageDispatch = (MessageDispatch)allArguments[0];
        AbstractSpan activeSpan = null;
        if (messageDispatch.getDestination().getDestinationType() == 1 || messageDispatch.getDestination().getDestinationType() == 5) {
            activeSpan = ContextManager.createEntrySpan((String)("ActiveMQ/Queue/" + messageDispatch.getDestination().getPhysicalName() + CONSUMER_OPERATE_NAME_SUFFIX), null).start(System.currentTimeMillis());
            Tags.MQ_BROKER.set(activeSpan, url);
            Tags.MQ_QUEUE.set(activeSpan, messageDispatch.getDestination().getPhysicalName());
        } else if (messageDispatch.getDestination().getDestinationType() == 2 || messageDispatch.getDestination().getDestinationType() == 6) {
            activeSpan = ContextManager.createEntrySpan((String)("ActiveMQ/Topic/" + messageDispatch.getDestination().getPhysicalName() + CONSUMER_OPERATE_NAME_SUFFIX), null).start(System.currentTimeMillis());
            Tags.MQ_BROKER.set(activeSpan, url);
            Tags.MQ_TOPIC.set(activeSpan, messageDispatch.getDestination().getPhysicalName());
        }
        activeSpan.setComponent((Component)ComponentsDefine.ACTIVEMQ_CONSUMER);
        SpanLayer.asMQ((AbstractSpan)activeSpan);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            Object propertyValue = messageDispatch.getMessage().getProperty(next.getHeadKey());
            if (propertyValue == null) continue;
            next.setHeadValue(propertyValue.toString());
        }
        ContextManager.extract((ContextCarrier)contextCarrier);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

