/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdk.threading.define;

import org.apache.skywalking.apm.agent.core.plugin.interceptor.ConstructorInterceptPoint;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.InstanceMethodsInterceptPoint;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.StaticMethodsInterceptPoint;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.ClassEnhancePluginDefine;
import org.apache.skywalking.apm.agent.core.plugin.match.ClassMatch;
import org.apache.skywalking.apm.agent.core.plugin.match.HierarchyMatch;
import org.apache.skywalking.apm.agent.core.plugin.match.IndirectMatch;
import org.apache.skywalking.apm.agent.core.plugin.match.logical.LogicalMatchOperation;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.description.method.MethodDescription;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.matcher.ElementMatchers;
import org.apache.skywalking.apm.plugin.jdk.threading.ThreadingConfig;

public class RunnableInstrumentation
extends ClassEnhancePluginDefine {
    private static final String RUNNABLE_CLASS = "java.lang.Runnable";
    private static final String RUNNABLE_CLASS_INTERCEPTOR = "org.apache.skywalking.apm.plugin.jdk.threading.ThreadingConstructorInterceptor";
    private static final String RUNNABLE_RUN_METHOD = "run";
    private static final String RUNNABLE_RUN_METHOD_INTERCEPTOR = "org.apache.skywalking.apm.plugin.jdk.threading.ThreadingMethodInterceptor";

    protected ClassMatch enhanceClass() {
        IndirectMatch prefixMatches = ThreadingConfig.prefixesMatchesForJdkThreading();
        if (prefixMatches == null) {
            return null;
        }
        return LogicalMatchOperation.and((IndirectMatch[])new IndirectMatch[]{prefixMatches, HierarchyMatch.byHierarchyMatch((String[])new String[]{RUNNABLE_CLASS})});
    }

    public ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return new ConstructorInterceptPoint[]{new ConstructorInterceptPoint(){

            public ElementMatcher<MethodDescription> getConstructorMatcher() {
                return ElementMatchers.any();
            }

            public String getConstructorInterceptor() {
                return RunnableInstrumentation.RUNNABLE_CLASS_INTERCEPTOR;
            }
        }};
    }

    public InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[]{new InstanceMethodsInterceptPoint(){

            public ElementMatcher<MethodDescription> getMethodsMatcher() {
                return ElementMatchers.named((String)RunnableInstrumentation.RUNNABLE_RUN_METHOD).and((ElementMatcher)ElementMatchers.takesArguments((int)0));
            }

            public String getMethodsInterceptor() {
                return RunnableInstrumentation.RUNNABLE_RUN_METHOD_INTERCEPTOR;
            }

            public boolean isOverrideArgs() {
                return false;
            }
        }};
    }

    public StaticMethodsInterceptPoint[] getStaticMethodsInterceptPoints() {
        return new StaticMethodsInterceptPoint[0];
    }

    public boolean isBootstrapInstrumentation() {
        return true;
    }
}

