/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.httpClient.v4;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.httpclient.HttpClientPluginConfig;
import org.apache.skywalking.apm.util.StringUtil;

public class HttpClientExecuteInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String requestURI;
        if (allArguments[0] == null || allArguments[1] == null) {
            return;
        }
        HttpHost httpHost = (HttpHost)allArguments[0];
        HttpRequest httpRequest = (HttpRequest)allArguments[1];
        ContextCarrier contextCarrier = new ContextCarrier();
        String remotePeer = httpHost.getHostName() + ":" + this.port(httpHost);
        String uri = httpRequest.getRequestLine().getUri();
        String operationName = requestURI = this.getRequestURI(uri);
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (ContextCarrier)contextCarrier, (String)remotePeer);
        span.setComponent((Component)ComponentsDefine.HTTPCLIENT);
        Tags.URL.set(span, this.buildSpanValue(httpHost, uri));
        Tags.HTTP.METHOD.set(span, httpRequest.getRequestLine().getMethod());
        SpanLayer.asHttp((AbstractSpan)span);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            httpRequest.setHeader(next.getHeadKey(), next.getHeadValue());
        }
        if (HttpClientPluginConfig.Plugin.HttpClient.COLLECT_HTTP_PARAMS) {
            this.collectHttpParam(httpRequest, span);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        HttpResponse response;
        StatusLine responseStatusLine;
        if (allArguments[0] == null || allArguments[1] == null) {
            return ret;
        }
        if (ret != null && (responseStatusLine = (response = (HttpResponse)ret).getStatusLine()) != null) {
            int statusCode = responseStatusLine.getStatusCode();
            AbstractSpan span = ContextManager.activeSpan();
            if (statusCode >= 400) {
                span.errorOccurred();
                Tags.STATUS_CODE.set(span, Integer.toString(statusCode));
            }
            HttpRequest httpRequest = (HttpRequest)allArguments[1];
            if (!HttpClientPluginConfig.Plugin.HttpClient.COLLECT_HTTP_PARAMS && span.isProfiling()) {
                this.collectHttpParam(httpRequest, span);
            }
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan activeSpan = ContextManager.activeSpan();
        activeSpan.log(t);
    }

    private String getRequestURI(String uri) throws MalformedURLException {
        if (this.isUrl(uri)) {
            String requestPath = new URL(uri).getPath();
            return requestPath != null && requestPath.length() > 0 ? requestPath : "/";
        }
        return uri;
    }

    private boolean isUrl(String uri) {
        String lowerUrl = uri.toLowerCase();
        return lowerUrl.startsWith("http") || lowerUrl.startsWith("https");
    }

    private String buildSpanValue(HttpHost httpHost, String uri) {
        if (this.isUrl(uri)) {
            return uri;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(httpHost.getSchemeName().toLowerCase());
        buff.append("://");
        buff.append(httpHost.getHostName());
        buff.append(":");
        buff.append(this.port(httpHost));
        buff.append(uri);
        return buff.toString();
    }

    private int port(HttpHost httpHost) {
        int port = httpHost.getPort();
        return port > 0 ? port : ("https".equals(httpHost.getSchemeName().toLowerCase()) ? 443 : 80);
    }

    private void collectHttpParam(HttpRequest httpRequest, AbstractSpan span) {
        URI uri;
        String tagValue;
        if (httpRequest instanceof HttpUriRequest && StringUtil.isNotEmpty((String)(tagValue = (uri = ((HttpUriRequest)httpRequest).getURI()).getQuery()))) {
            tagValue = HttpClientPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)HttpClientPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD) : tagValue;
            Tags.HTTP.PARAMS.set(span, tagValue);
        }
    }
}

