/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultNamedThreadFactory;
import org.apache.skywalking.apm.agent.core.boot.OverrideImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.jvm.LoadedLibraryCollector;
import org.apache.skywalking.apm.agent.core.kafka.KafkaConnectionStatus;
import org.apache.skywalking.apm.agent.core.kafka.KafkaConnectionStatusListener;
import org.apache.skywalking.apm.agent.core.kafka.KafkaProducerManager;
import org.apache.skywalking.apm.agent.core.kafka.KafkaReporterPluginConfig;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.os.OSUtil;
import org.apache.skywalking.apm.agent.core.remote.ServiceManagementClient;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.management.v3.InstancePingPkg;
import org.apache.skywalking.apm.network.management.v3.InstanceProperties;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;

@OverrideImplementor(value=ServiceManagementClient.class)
public class KafkaServiceManagementServiceClient
implements BootService,
Runnable,
KafkaConnectionStatusListener {
    private static final ILog LOGGER = LogManager.getLogger(KafkaServiceManagementServiceClient.class);
    private static List<KeyStringValuePair> SERVICE_INSTANCE_PROPERTIES;
    private static final String TOPIC_KEY_REGISTER = "register-";
    private ScheduledFuture<?> heartbeatFuture;
    private KafkaProducer<String, Bytes> producer;
    private String topic;
    private AtomicInteger sendPropertiesCounter = new AtomicInteger(0);

    public void prepare() {
        KafkaProducerManager producerManager = (KafkaProducerManager)ServiceManager.INSTANCE.findService(KafkaProducerManager.class);
        producerManager.addListener(this);
        this.topic = producerManager.formatTopicNameThenRegister(KafkaReporterPluginConfig.Plugin.Kafka.TOPIC_MANAGEMENT);
        SERVICE_INSTANCE_PROPERTIES = new ArrayList<KeyStringValuePair>();
        for (String key : Config.Agent.INSTANCE_PROPERTIES.keySet()) {
            SERVICE_INSTANCE_PROPERTIES.add(KeyStringValuePair.newBuilder().setKey(key).setValue((String)Config.Agent.INSTANCE_PROPERTIES.get(key)).build());
        }
    }

    public void boot() {
        this.heartbeatFuture = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultNamedThreadFactory("ServiceManagementClientKafkaProducer")).scheduleAtFixedRate((Runnable)new RunnableWithExceptionProtection((Runnable)this, t -> LOGGER.error("unexpected exception.", t)), 0L, Config.Collector.HEARTBEAT_PERIOD, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (this.producer == null) {
            return;
        }
        if (Math.abs(this.sendPropertiesCounter.getAndAdd(1)) % Config.Collector.PROPERTIES_REPORT_PERIOD_FACTOR == 0) {
            InstanceProperties instance = InstanceProperties.newBuilder().setService(Config.Agent.SERVICE_NAME).setServiceInstance(Config.Agent.INSTANCE_NAME).addAllProperties((Iterable)OSUtil.buildOSInfo((int)Config.OsInfo.IPV4_LIST_SIZE)).addAllProperties(SERVICE_INSTANCE_PROPERTIES).addAllProperties((Iterable)LoadedLibraryCollector.buildJVMInfo()).build();
            this.producer.send(new ProducerRecord<String, Bytes>(this.topic, TOPIC_KEY_REGISTER + instance.getServiceInstance(), Bytes.wrap(instance.toByteArray())));
            this.producer.flush();
        } else {
            InstancePingPkg ping = InstancePingPkg.newBuilder().setService(Config.Agent.SERVICE_NAME).setServiceInstance(Config.Agent.INSTANCE_NAME).build();
            if (LOGGER.isDebugEnable()) {
                LOGGER.debug("Heartbeat reporting, instance: {}", new Object[]{ping.getServiceInstance()});
            }
            this.producer.send(new ProducerRecord<String, Bytes>(this.topic, ping.getServiceInstance(), Bytes.wrap(ping.toByteArray())));
        }
    }

    public void onComplete() {
    }

    @Override
    public void onStatusChanged(KafkaConnectionStatus status) {
        if (status == KafkaConnectionStatus.CONNECTED) {
            this.producer = ((KafkaProducerManager)ServiceManager.INSTANCE.findService(KafkaProducerManager.class)).getProducer();
        }
    }

    public void shutdown() {
        this.heartbeatFuture.cancel(true);
    }
}

