/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.webflux.v5;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebExchangeDecorator;
import org.springframework.web.server.adapter.DefaultServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

public class DispatcherHandlerHandleMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        EnhancedInstance instance = DispatcherHandlerHandleMethodInterceptor.getInstance(allArguments[0]);
        ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
        ContextCarrier carrier = new ContextCarrier();
        CarrierItem next = carrier.items();
        HttpHeaders headers = exchange.getRequest().getHeaders();
        while (next.hasNext()) {
            List header = headers.get((Object)(next = next.next()).getHeadKey());
            if (header == null || header.size() <= 0) continue;
            next.setHeadValue((String)header.get(0));
        }
        AbstractSpan span = ContextManager.createEntrySpan((String)exchange.getRequest().getURI().getPath(), (ContextCarrier)carrier);
        if (instance != null && instance.getSkyWalkingDynamicField() != null) {
            ContextManager.continued((ContextSnapshot)((ContextSnapshot)instance.getSkyWalkingDynamicField()));
        }
        span.setComponent((Component)ComponentsDefine.SPRING_WEBFLUX);
        SpanLayer.asHttp((AbstractSpan)span);
        Tags.URL.set(span, exchange.getRequest().getURI().toString());
        Tags.HTTP.METHOD.set(span, exchange.getRequest().getMethodValue());
        instance.setSkyWalkingDynamicField((Object)ContextManager.capture());
        span.prepareForAsync();
        ContextManager.stopSpan((AbstractSpan)span);
        exchange.getAttributes().put("SKYWALING_SPAN", span);
    }

    private void maybeSetPattern(AbstractSpan span, ServerWebExchange exchange) {
        PathPattern pathPattern;
        if (span != null && (pathPattern = (PathPattern)exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE)) != null && pathPattern.matches(exchange.getRequest().getPath().pathWithinApplication())) {
            span.setOperationName(pathPattern.getPatternString());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
        AbstractSpan span = (AbstractSpan)exchange.getAttributes().get("SKYWALING_SPAN");
        return ((Mono)ret).doFinally(s -> {
            if (span != null) {
                this.maybeSetPattern(span, exchange);
                try {
                    HttpStatus httpStatus = exchange.getResponse().getStatusCode();
                    if (httpStatus != null) {
                        Tags.STATUS_CODE.set(span, Integer.toString(httpStatus.value()));
                        if (httpStatus.isError()) {
                            span.errorOccurred();
                        }
                    }
                }
                finally {
                    span.asyncFinish();
                }
            }
        });
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    public static EnhancedInstance getInstance(Object o) {
        EnhancedInstance instance = null;
        if (o instanceof DefaultServerWebExchange) {
            instance = (EnhancedInstance)o;
        } else if (o instanceof ServerWebExchangeDecorator) {
            ServerWebExchange delegate = ((ServerWebExchangeDecorator)o).getDelegate();
            return DispatcherHandlerHandleMethodInterceptor.getInstance(delegate);
        }
        return instance;
    }
}

