package com.luca.pilot.entity;


import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

/**
 * @author linfeng.yang
 * @date 2021/8/03 下午14:40
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@Document("scale_module")
public class ScaleModuleEntity extends AbstractAuditingEntity {

    private Long id;
    private String code;
    @Field("project_code")
    private String projectCode;
    @Field("module_code")
    private String moduleCode;
    @Field("scale_code")
    private String scaleCode;
    private Integer enabled;
}
