package com.luca.pilot.entity;

import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * Base abstract class for entities which will hold definitions for created, last modified by date.
 */
@Data
public abstract class AbstractAuditingEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @Field("created_by")
    private String createdBy;

    @Field("created_at")
    private String createdAt;

    @Field("last_modified_by")
    private String lastModifiedBy;

    @Field("last_modified_at")
    private String lastModifiedAt;

    /**
     * 删除标记（false:未删除 true:已删除）
     */
    private boolean deleted = false;

}
