package com.luca.pilot.entity;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Data
@Accessors(chain = true)
@Document(collection = "base_module_view")
public class BaseModuleView {

    private Long id;

    @Field("tenant_id")
    private Long tenantId;

    private String name;

    @Field("module_item_type")
    private String moduleItemType;

    private Integer status;

    @Field("module_code")
    private String moduleCode;

    @Field("module_enabled")
    private Boolean moduleEnabled;

    @Field("module_type")
    private String moduleType;

    @Field("project_code")
    private String projectCode;

    @Field("project_enabled")
    private Boolean projectEnabled;

    @Field("collect_type")
    private String collectType;

    @Field("local_algorithm")
    private String localAlgorithm;

    @Field("supplement_img_url")
    private String supplementImgUrl;

    @Field("supplement_media_url")
    private String supplementMediaUrl;

    @Field("collect_duration")
    private String collectDuration;

    @Field("description")
    private String description;

    private String deleted;

    @Field("created_at")
    private String createdAt;

}
