package com.luca.pilot.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

/**
 * @author jiangbangfa
 * @date 2021/7/20 上午9:39
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@Document("module")
public class ModuleEntity extends AbstractAuditingEntity {

    private Long id;

    /**
     * 项目code
     */
    @Field("project_code")
    private String projectCode;

    /**
     * 模块code
     */
    private String code;

    /**
     * 模块名称
     */
    private String name;

    /**
     * 模块类型
     */
    private String type;

    /**
     * 模块状态
     */
    private Boolean enabled;

}
