package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.time.LocalDate;

/**
 * <p>
 * 计划表
 * </p>
 *
 * @author Lt
 * @since 2021-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Document(collection="plan")
public class Plan extends AbstractAuditingEntity {

    /**
     * id
     */
    private Long id;

    /**
     * 租户id
     */
    @Field("tenant_id")
    private Long tenantId;

    /**
     * 项目id
     */
    @Field("project_id")
    private Long projectId;

    /**
     * 计划名称
     */
    private String name;

    /**
     * 计划编号
     */
    private String number;

    /**
     * 生效日期
     */
    @Field("effective_date")
    private LocalDate effectiveDate;

    /**
     * 计划天数
     */
    private Integer days;

    /**
     * 描述
     */
    private String description;

    /**
     * 是否启用(0:禁用 1:启用)
     */
    private Boolean enabled;

    /**
     * 计划二维码
     */
    @Field("plan_url")
    private String planUrl;

    /**
     * 标签ids
     */
    @Field("patient_tags")
    private String patientTags;

    /**
     * 是否需要医生审核  0 不需要  1 需要
     */
    @Field("doctor_audit")
    private Integer doctorAudit;



}
