package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

/**
 * <p>
 * 患者任务计划
 * </p>
 *
 * @author Lt
 * @since 2021-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Document(collection="plan_task")
public class PlanTask extends AbstractAuditingEntity {

    /**
     * id
     */
    private Long id;

    /**
     * 租户id
     */
    @Field("tenant_id")
    private Long tenantId;

    /**
     * 项目id
     */
    @Field("project_id")
    private Long projectId;

    /**
     * 计划id
     */
    @Field("plan_id")
    private Long planId;

    /**
     * 任务名称
     */
    @Field("name")
    private String name;

    /**
     * 任务描述
     */
    @Field("description")
    private String description;

    /**
     * 循环类型(1:周 2:月 3:项目)
     */
    @Field("loop_type")
    private Integer loopType;

    /**
     * 执行类型(循环类型=周 1:指定星期 2:循环周内几次;  循环类型=月 1:从当月几日开始 2:指定日期)
     */
    @Field("execute_type")
    private Integer executeType;

    /**
     * 执行日期(cron表达式简化)
     */
    @Field("execute_cron")
    private String executeCron;

    /**
     * 周执行频次(循环类型为周类型,循环周内几次时设值)
     */
    @Field("week_frequency")
    private Integer weekFrequency;

    /**
     * 是否启用(0:禁用 1:启用)
     */
    @Field("enabled")
    private Boolean enabled;

    /**
     * 计划目标id
     */
    @Field("target_id")
    private Long targetId;
    /**
     * 窗口期
     */
    @Field("window_phase")
    private Integer windowPhase;

    /**
     * 预约时间
     */
    @Field("reserve_time")
    private String reserveTime;

    /**
     * 共需多少天
     */
    @Field("finish_day")
    private Integer finishDay;

    /**
     * 任务类型(0:患者任务 1:医生随访)
     */
    @Field("task_type")
    private Integer taskType;

    /**
     * 一日需完成次数
     */
    @Field("task_count")
    private Integer taskCount;

    /**
     * 是否开启窗口期 1开启 0 未开启
     */
    @Field("is_window_phase")
    private Integer isWindowPhase;

    /**
     * 是否循环 1是 0 否
     */
    @Field("is_circulation")
    private Integer isCirculation;

    /**
     * 第几天循环
     */
    @Field("circulation_day")
    private Integer circulationDay;

    /**
     * 第几天开始
     */
    @Field("begin_day")
    private Integer beginDay;

    /**
     * 入组类型随访结束于第几天，0为至随访结束
     */
    @Field("end_day")
    private Integer endDay;

    /**
     * 分组id
     */
    @Field("group_id")
    private Long groupId;

}
