package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

/**
 * <p>
 * 患者任务计划详情表
 * </p>
 *
 * @author Lt
 * @since 2021-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Document(collection = "plan_task_details_module")
public class PlanTaskDetailsModule extends AbstractAuditingEntity {

    /**
     * id
     */
//    @TableId(type = IdType.INPUT)
    private Long id;

    /**
     * 租户id
     */
    private Long tenantId;

    /**
     * 患者任务计划详情id
     */
    @Field("plan_task_details_id")
    private Long planTaskDetailsId;

    /**
     * 关联项目类型
     */
    @Field("relation_type")
    private String relationType;

    /**
     * 关联id
     */
    @Field("relation_id")
    private Long relationId;

    /**
     * 模块任务完成状态(0:未完成 1:已完成)
     */
    @Field("module_complete")
    private Integer moduleComplete;

    /**
     * 忽略备注
     */
    @Field("ignore_remark")
    private String ignoreRemark;

}
