package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@EqualsAndHashCode(callSuper = true)
@Data
@Document(collection="site")
public class Site extends AbstractAuditingEntity {
    /**
     * siteId
     */
    private Long id;

    /**
     * 租户id
     */
    private Long tenantId;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * site名称(L:32)
     */
    @Field("site_name")
    private String siteName;

    /**
     * 描述(L:128)
     */
    private String description;

    /**
     * logo
     */
    private String logoUrl;

    /**
     * 知情同意书文本
     */
    private String agreementText;

    /**
     * 知情同意类型  0 无 1 通用模板  2 site自定义
     */
    private Integer agreementType;

    /**
     * 目标患者数
     */
    private Long targetPatientsNum;

    /**
     * 省级id
     */
    private Long provinceId;

    /**
     * 市级id
     */
    private Long cityId;

    /**
     * 区/县级id
     */
    private Long areaId;

    /**
     * 省级-市级-区/县级
     */
    private String address;

    /**
     * 时区
     */
    private String timeZone;

    /**
     * 启用状态
     */
    private Boolean enable;


}