package com.luca.pilot.service.impl;

import com.luca.pilot.entity.BaseModuleView;
import com.luca.pilot.entity.ModuleEntity;
import com.luca.pilot.entity.ScaleModuleDetailsEntity;
import com.luca.pilot.entity.ScaleModuleEntity;
import com.luca.pilot.service.BaseModuleViewService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Slf4j
@Service
public class BaseModuleViewServiceImpl implements BaseModuleViewService {

    @Resource(name = "mongoTemplate")
    private MongoTemplate mongoTemplate;

    @Override
    public void synchronizeModuleView() {
        queryScale();
    }

    private void queryScale() {
        List<ScaleModuleDetailsEntity> scaleModuleDetailsList = mongoTemplate.findAll(ScaleModuleDetailsEntity.class);
        List<ScaleModuleEntity> scaleModuleList = mongoTemplate.findAll(ScaleModuleEntity.class);
        List<ModuleEntity> moduleList = mongoTemplate.findAll(ModuleEntity.class);

        List<BaseModuleView> views = scaleModuleDetailsList.stream().map(x -> {
            ScaleModuleEntity sm = scaleModuleList.stream().filter(y -> y.getScaleCode().equals(x.getCode())).findFirst().orElse(null);
            if(Objects.nonNull(sm)) {
                ModuleEntity m = moduleList.stream().filter(y -> y.getCode().equals(sm.getModuleCode())).findFirst().orElse(null);
                BaseModuleView view = new BaseModuleView()
                        .setId(x.getId())
                        .setName(x.getName())
                        .setStatus(x.getStatus())
                        .setModuleCode(Objects.isNull(sm) ? "" : sm.getScaleCode())
                        .setModuleEnabled(Objects.isNull(sm) ? null : sm.getEnabled())
                        .setModuleType(Objects.isNull(m) ? "" : m.getType())
                        .setProjectCode(Objects.isNull(m) ? "" : m.getProjectCode())
                        .setProjectEnabled(Objects.isNull(m) ? null : m.getEnabled());
                return view;
            }
            return null;
        }).collect(Collectors.toList());

        mongoTemplate.insertAll(views);
    }

}
