package com.luca.pilot;

import cn.hutool.json.JSONUtil;
import com.luca.pilot.entity.UserArchive;
import com.luca.pilot.service.BaseModuleViewService;
import com.luca.pilot.service.PlanService;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.test.context.ActiveProfiles;

import java.util.List;

@Slf4j
@SpringBootTest
@ActiveProfiles("hj")
public class PlanTaskTest {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private PlanService planService;
    @Autowired
    private BaseModuleViewService baseModuleViewService;


    @Test
    void synchronizePlanTask2() {
        // 创建查询条件
        Query query = new Query();
        query.addCriteria(Criteria.where("createAt").lt("2023-12-07 14:50"));
        long count = mongoTemplate.count(query, UserArchive.class);
        log.info("total count:{}", count);

        long skip = count / 10;
        if (count % 10 > 0) {
            skip++;
        }


        for (int i = 0; i < skip; i++) {
            query.skip(i * 10L);
            query.limit(10);
            List<UserArchive> userArchives = mongoTemplate.find(query, UserArchive.class);
            log.info("userArchives count:{}", userArchives.size());
        }

    }

    @Test
    void synchronizeModuleView() {
        baseModuleViewService.synchronizeModuleView();
    }



    @Test
    void synchronizePlanTask() {
        planService.synchronizePlanTask();
    }

    @Test
    void contextLoads() {
        Book book = new Book();
        book.setId(10);
        book.setName("testMongoDB");
        book.setType("testMongoDB");
        book.setDescription("testMongoDB");
        mongoTemplate.save(book);
    }

    @Test
    void find() {
        List<Book> all = mongoTemplate.findAll(Book.class);
        System.out.println(all);
    }

    @Data
    class Book {
        private int id;
        private String name;
        private String type;
        private String description;
    }
}

