package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@Document("crf_answer")
public class CrfAnswer extends AbstractAuditingEntity implements Serializable {


    private static final long serialVersionUID = 1L;


    /**
     * CrfAnswer表主键ID
     */
    private Long id;

    /**
     * crf表ID
     */
    @Field("crf_id")
    private Long crfId;

    /**
     * crfTop表主键ID
     */
    @Field("crf_top_id")
    private Long crfTopId;

    /**
     * 租户ID
     */
    private Long tenantId;


    /**
     * 答案的大json
     */
    @Field("answer_json")
    private String answerJson;

    @Field("plan_task_details_id")
    private Long planTaskDetailsId;

    /**
     * SiteId
     */
    private String siteId;

    /**
     * projectCode
     */
    private String projectCode;

    /**
     * patientCode
     */
    private String patientCode;



}
