package com.luca.pilot.entity;

import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

@Data
@Document(collection="plan_module")
public class PlanModule {

    private String key;
    /**
     * 患者编号
     */
    private String subjectId;
    /**
     * 随机数
     */
    private String randomizationId;


    /**
     * plan
     */
    private String projectCode;
    private String projectName;
    private String siteName;
    private Long planId;
    private String planCode;
    private String planEffectiveDate;
    private Integer planDuration;

    /**
     * plan task
     */
    private String planTaskName;
    private String planTaskdescription;
    private Integer planTaskType;
    private Integer planTaskTaskCount;
    private Integer planTaskFinishDay;
    private Integer planTaskLoopType;
    private Integer planTaskEnabled;
    private Integer planTaskIsCirculation;
    private Integer planTaskBeginDay;
    private Integer planTaskCirculationDay;
    private Integer planTaskWindowPhase;
    private Integer planTaskEndDay;

    /**
     * plan task detail
     */
    private String taskStartDate;
    private String taskEndDate;
    private Integer taskCompleteStatus;
    private String taskCompleteTime;
    private Integer taskEnabled;
    private Integer taskCompleteOrder;

    /**
     * plan module relate
     */
    private String moduleType;
    private Long moduleId;
    private String moduleName;



    /**
     * plan task detail module
     */
    private Integer moduleComplete;
    private String moduleIgnoreRemark;
    private String moduleFinishTime;

    /**
     * 组装
     */
    private String result;
    private String digitalModuleTableName;

    /**
     * event
     */
    private Long digitalModuleEventId;
}
