package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;

/**
 * <p>
 * 
 * </p>
 *
 * @author linfeng.yang
 * @since 2021-10-21
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@Document("questionnaire")
public class Questionnaire extends AbstractAuditingEntity implements Serializable {

    private static final long serialVersionUID = 1L;
    private Long id;

    private String url;

    private String name;

    private String description;

    private Integer status;

    @Field("top_id")
    private Long topId;

    private Long sourceId;

    private Long tenantId;

}
