/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jsonrpc4j;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.util.MethodUtil;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class JsonServiceExporterInterceptor
implements InstanceMethodsAroundInterceptor {
    private static boolean IS_SERVLET_GET_STATUS_METHOD_EXIST = MethodUtil.isMethodExist((ClassLoader)JsonServiceExporterInterceptor.class.getClassLoader(), (String)"javax.servlet.http.HttpServletResponse", (String)"getStatus", (String[])new String[0]);
    private static final String SERVLET_RESPONSE_CLASS = "javax.servlet.http.HttpServletResponse";
    private static final String GET_STATUS_METHOD = "getStatus";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] objects, Class<?>[] classes, MethodInterceptResult result) throws Throwable {
        HttpServletRequest request = (HttpServletRequest)objects[0];
        ContextCarrier contextCarrier = new ContextCarrier();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            next.setHeadValue(request.getHeader(next.getHeadKey()));
        }
        AbstractSpan span = ContextManager.createEntrySpan((String)request.getRequestURI(), (ContextCarrier)contextCarrier);
        Tags.HTTP.METHOD.set(span, request.getMethod());
        Tags.URL.set(span, request.getRequestURL().toString());
        span.setComponent((Component)ComponentsDefine.JSON_RPC);
        SpanLayer.asRPCFramework((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] objects, Class<?>[] classes, Object ret) throws Throwable {
        HttpServletResponse response = (HttpServletResponse)objects[1];
        AbstractSpan span = ContextManager.activeSpan();
        if (IS_SERVLET_GET_STATUS_METHOD_EXIST) {
            Tags.STATUS_CODE.set(span, String.valueOf(response.getStatus()));
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] objects, Class<?>[] classes, Throwable throwable) {
    }
}

