/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.vertx3;

import io.vertx.core.http.HttpClientRequest;
import io.vertx.ext.web.client.impl.HttpContext;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.vertx3.HttpClientRequestImplInterceptor;
import org.apache.skywalking.apm.plugin.vertx3.VertxContext;

public class HttpContextHandleDispatchResponseInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        HttpContext httpContext = (HttpContext)objInst;
        HttpClientRequest clientRequest = httpContext.clientRequest();
        VertxContext context = ((HttpClientRequestImplInterceptor.HttpClientRequestContext)((EnhancedInstance)clientRequest).getSkyWalkingDynamicField()).vertxContext;
        Tags.STATUS_CODE.set(context.getSpan(), Integer.toString(httpContext.clientResponse().statusCode()));
        context.getSpan().asyncFinish();
        AbstractSpan span = ContextManager.createLocalSpan((String)("#" + context.getSpan().getOperationName()));
        span.setComponent((Component)ComponentsDefine.VERTX);
        SpanLayer.asHttp((AbstractSpan)span);
        ContextManager.continued((ContextSnapshot)context.getContextSnapshot());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

