/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.mvc.commons.interceptor;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.ParsePathUtil;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.interceptor.AbstractMethodInterceptor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class RequestMappingMethodInterceptor
extends AbstractMethodInterceptor {
    @Override
    public String getRequestURL(Method method) {
        return ParsePathUtil.recursiveParseMethodAnnotation(method, m -> {
            String requestURL = null;
            RequestMapping methodRequestMapping = (RequestMapping)AnnotationUtils.getAnnotation((Method)m, RequestMapping.class);
            if (methodRequestMapping != null) {
                requestURL = methodRequestMapping.value().length > 0 ? methodRequestMapping.value()[0] : "";
            }
            return requestURL;
        });
    }

    @Override
    public String getAcceptedMethodTypes(Method method) {
        return ParsePathUtil.recursiveParseMethodAnnotation(method, m -> {
            RequestMapping methodRequestMapping = (RequestMapping)AnnotationUtils.getAnnotation((Method)m, RequestMapping.class);
            if (methodRequestMapping == null || methodRequestMapping.method().length == 0) {
                return null;
            }
            StringBuilder methodTypes = new StringBuilder();
            methodTypes.append("{");
            for (int i = 0; i < methodRequestMapping.method().length; ++i) {
                methodTypes.append(methodRequestMapping.method()[i].toString());
                if (methodRequestMapping.method().length <= i + 1) continue;
                methodTypes.append(",");
            }
            methodTypes.append("}");
            return methodTypes.toString();
        });
    }
}

