/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.lettuce.v5;

import io.lettuce.core.protocol.AsyncCommand;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.lettuce.v5.SWBiConsumer;
import org.apache.skywalking.apm.plugin.lettuce.v5.SWConsumer;

public class AsyncCommandMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        AsyncCommand asyncCommand = (AsyncCommand)objInst;
        String operationName = "Lettuce/" + asyncCommand.getType().name();
        AbstractSpan span = ContextManager.createLocalSpan((String)(operationName + "/onComplete"));
        span.setComponent((Component)ComponentsDefine.LETTUCE);
        Tags.DB_TYPE.set(span, "Redis");
        SpanLayer.asCache((AbstractSpan)span);
        allArguments[0] = allArguments[0] instanceof Consumer ? new SWConsumer((Consumer)allArguments[0], ContextManager.capture(), operationName) : new SWBiConsumer((BiConsumer)allArguments[0], ContextManager.capture(), operationName);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

