/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.webflux.v5.webclient;

import java.lang.reflect.Method;
import java.net.URI;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.InstanceMethodsAroundInterceptorV2;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.v2.MethodInvocationContext;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientRequest;
import reactor.core.publisher.Mono;

public class WebFluxWebClientInterceptor
implements InstanceMethodsAroundInterceptorV2 {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInvocationContext context) throws Throwable {
        String requestURIString;
        if (allArguments[0] == null) {
            return;
        }
        ClientRequest request = (ClientRequest)allArguments[0];
        ContextCarrier contextCarrier = new ContextCarrier();
        URI uri = request.url();
        String operationName = requestURIString = this.getRequestURIString(uri);
        String remotePeer = this.getIPAndPort(uri);
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (ContextCarrier)contextCarrier, (String)remotePeer);
        span.setComponent((Component)ComponentsDefine.SPRING_WEBCLIENT);
        Tags.URL.set(span, uri.toString());
        Tags.HTTP.METHOD.set(span, request.method().toString());
        SpanLayer.asHttp((AbstractSpan)span);
        if (request instanceof EnhancedInstance) {
            ((EnhancedInstance)request).setSkyWalkingDynamicField((Object)contextCarrier);
        }
        span.prepareForAsync();
        ContextManager.stopSpan();
        context.setContext((Object)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret, MethodInvocationContext context) throws Throwable {
        if (allArguments[0] == null) {
            return ret;
        }
        Mono ret1 = (Mono)ret;
        AbstractSpan span = (AbstractSpan)context.getContext();
        return ret1.doOnSuccess(clientResponse -> {
            HttpStatus httpStatus = clientResponse.statusCode();
            if (httpStatus != null) {
                Tags.STATUS_CODE.set(span, Integer.toString(httpStatus.value()));
                if (httpStatus.isError()) {
                    span.errorOccurred();
                }
            }
        }).doOnError(error -> span.log(error)).doFinally(s -> span.asyncFinish());
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t, MethodInvocationContext context) {
        AbstractSpan activeSpan = ContextManager.activeSpan();
        activeSpan.errorOccurred();
        activeSpan.log(t);
    }

    private String getRequestURIString(URI uri) {
        String requestPath = uri.getPath();
        return requestPath != null && requestPath.length() > 0 ? requestPath : "/";
    }

    private String getIPAndPort(URI uri) {
        return uri.getHost() + ":" + uri.getPort();
    }
}

