/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticsearch.v6.interceptor;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.elasticsearch.v6.ElasticsearchPluginConfig;
import org.apache.skywalking.apm.plugin.elasticsearch.v6.RestClientEnhanceInfo;
import org.elasticsearch.client.indices.CreateIndexRequest;

public class IndicesClientCreateMethodsInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        CreateIndexRequest createIndexRequest = (CreateIndexRequest)allArguments[0];
        RestClientEnhanceInfo restClientEnhanceInfo = (RestClientEnhanceInfo)objInst.getSkyWalkingDynamicField();
        if (restClientEnhanceInfo != null) {
            AbstractSpan span = ContextManager.createExitSpan((String)"Elasticsearch/CreateRequest", (String)restClientEnhanceInfo.getPeers());
            span.setComponent((Component)ComponentsDefine.REST_HIGH_LEVEL_CLIENT);
            Tags.DB_TYPE.set(span, "Elasticsearch");
            Tags.DB_INSTANCE.set(span, createIndexRequest.index());
            if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
                Tags.DB_STATEMENT.set(span, createIndexRequest.mappings().utf8ToString());
            }
            SpanLayer.asDB((AbstractSpan)span);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        RestClientEnhanceInfo restClientEnhanceInfo = (RestClientEnhanceInfo)objInst.getSkyWalkingDynamicField();
        if (restClientEnhanceInfo != null) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        RestClientEnhanceInfo restClientEnhanceInfo = (RestClientEnhanceInfo)objInst.getSkyWalkingDynamicField();
        if (restClientEnhanceInfo != null) {
            ContextManager.activeSpan().log(t);
        }
    }
}

