/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.solrj;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.solrj.SolrJPluginConfig;
import org.apache.skywalking.apm.plugin.solrj.commons.SolrjInstance;
import org.apache.skywalking.apm.plugin.solrj.commons.SolrjTags;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public class SolrClientInterceptor
implements InstanceMethodsAroundInterceptor,
InstanceConstructorInterceptor {
    private static final String DB_TYPE = "Solr";

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        SolrjInstance instance = new SolrjInstance();
        HttpSolrClient client = (HttpSolrClient)objInst;
        try {
            URL url = new URL(client.getBaseURL());
            instance.setRemotePeer(url.getHost() + ":" + url.getPort());
            String path = url.getPath();
            int idx = path.lastIndexOf(47);
            if (idx > 0) {
                instance.setCollection(path.substring(idx + 1));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        objInst.setSkyWalkingDynamicField((Object)instance);
    }

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        SolrRequest request = (SolrRequest)allArguments[0];
        SolrjInstance instance = (SolrjInstance)objInst.getSkyWalkingDynamicField();
        SolrParams params = SolrClientInterceptor.getParams(request.getParams());
        String collection = SolrClientInterceptor.getCollection(instance, allArguments[2]);
        if ("/update".equals(request.getPath())) {
            AbstractUpdateRequest update = (AbstractUpdateRequest)request;
            AbstractUpdateRequest.ACTION action = update.getAction();
            if (action == null) {
                if (update instanceof UpdateRequest) {
                    AbstractSpan span = null;
                    UpdateRequest ur = (UpdateRequest)update;
                    List documents = ur.getDocuments();
                    if (documents == null) {
                        String actionName = "DELETE_BY_IDS";
                        ArrayList deleteBy = ur.getDeleteById();
                        if (deleteBy == null) {
                            actionName = "DELETE_BY_QUERY";
                            deleteBy = ur.getDeleteQuery();
                        }
                        if (deleteBy == null) {
                            deleteBy = new ArrayList();
                        }
                        String operator = SolrClientInterceptor.getOperatorNameWithAction(collection, request.getPath(), actionName);
                        span = SolrClientInterceptor.getSpan(operator, instance.getRemotePeer());
                        if (SolrJPluginConfig.Plugin.SolrJ.TRACE_STATEMENT) {
                            span.tag((AbstractTag)Tags.DB_STATEMENT, ((Object)deleteBy).toString());
                        }
                    } else {
                        String operator = SolrClientInterceptor.getOperatorNameWithAction(collection, request.getPath(), "ADD");
                        span = SolrClientInterceptor.getSpan(operator, instance.getRemotePeer());
                        if (SolrJPluginConfig.Plugin.SolrJ.TRACE_STATEMENT) {
                            span.tag((AbstractTag)SolrjTags.TAG_DOCS_SIZE, String.valueOf(documents.size()));
                        }
                    }
                    if (SolrJPluginConfig.Plugin.SolrJ.TRACE_OPS_PARAMS) {
                        span.tag((AbstractTag)SolrjTags.TAG_COMMIT_WITHIN, String.valueOf(ur.getCommitWithin()));
                    }
                } else {
                    SolrClientInterceptor.getSpan(SolrClientInterceptor.getOperatorName(collection, request.getPath()), instance.getRemotePeer());
                }
            } else {
                String operator = SolrClientInterceptor.getOperatorNameWithAction(collection, request.getPath(), action.name());
                AbstractSpan span = SolrClientInterceptor.getSpan(operator, instance.getRemotePeer());
                if (SolrJPluginConfig.Plugin.SolrJ.TRACE_OPS_PARAMS) {
                    if (action == AbstractUpdateRequest.ACTION.COMMIT) {
                        span.tag((AbstractTag)SolrjTags.TAG_SOFT_COMMIT, params.get("softCommit", ""));
                    } else {
                        span.tag((AbstractTag)SolrjTags.TAG_MAX_OPTIMIZE_SEGMENTS, params.get("maxSegments", "1"));
                    }
                }
            }
        } else if (request instanceof QueryRequest) {
            AbstractSpan span = SolrClientInterceptor.getSpan(SolrClientInterceptor.getOperatorName(collection, request.getPath()), instance.getRemotePeer());
            span.tag((AbstractTag)SolrjTags.TAG_START, params.get("start", "0"));
            span.tag((AbstractTag)SolrjTags.TAG_QT, params.get("qt", request.getPath()));
            if (SolrJPluginConfig.Plugin.SolrJ.TRACE_STATEMENT) {
                span.tag((AbstractTag)Tags.DB_STATEMENT, SolrClientInterceptor.toQueryString(params));
            }
        } else {
            SolrClientInterceptor.getSpan(SolrClientInterceptor.getOperatorName(collection, request.getPath()), instance.getRemotePeer());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (!ContextManager.isActive()) {
            return ret;
        }
        AbstractSpan span = ContextManager.activeSpan();
        if (ret != null) {
            SolrDocumentList list;
            NamedList result = (NamedList)ret;
            NamedList header = (NamedList)result.get("responseHeader");
            if (header != null) {
                span.tag((AbstractTag)SolrjTags.TAG_Q_TIME, String.valueOf(header.get("QTime")));
            }
            if ((list = (SolrDocumentList)result.get("response")) != null) {
                span.tag((AbstractTag)SolrjTags.TAG_NUM_FOUND, String.valueOf(list.getNumFound()));
            }
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            AbstractSpan span = ContextManager.activeSpan();
            int code = 500;
            if (t instanceof SolrException) {
                code = ((SolrException)t).code();
            }
            span.tag((AbstractTag)SolrjTags.TAG_STATUS, String.valueOf(code));
            span.log(t);
        }
    }

    private static final AbstractSpan getSpan(String operatorName, String remotePeer) {
        return ContextManager.createExitSpan((String)operatorName, (String)remotePeer).setComponent((Component)ComponentsDefine.SOLRJ).setLayer(SpanLayer.DB).tag((AbstractTag)Tags.DB_TYPE, DB_TYPE);
    }

    private static final String getOperatorNameWithAction(String collection, String path, String action) {
        return "solrJ/" + collection + path + "/" + action;
    }

    private static final String getOperatorName(String collection, String path) {
        return "solrJ/" + collection + path;
    }

    private static final String getCollection(SolrjInstance instance, Object argument) {
        if (null == argument) {
            return instance.getCollection();
        }
        return String.valueOf(argument);
    }

    private static final SolrParams getParams(SolrParams params) {
        if (params == null) {
            return new ModifiableSolrParams();
        }
        return params;
    }

    private static final String toQueryString(SolrParams params) {
        StringBuilder sb = new StringBuilder(128);
        boolean first = true;
        Iterator it = params.getParameterNamesIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            for (String val : params.getParams(name)) {
                sb.append(first ? (char)'?' : '&').append(name).append('=').append(val);
                first = false;
            }
        }
        return sb.toString();
    }
}

