/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.cloud.gateway.v3x;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.spring.cloud.gateway.v3x.define.EnhanceObjectCache;
import org.reactivestreams.Publisher;

public class HttpClientFinalizerResponseConnectionInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        BiFunction finalReceiver = (BiFunction)allArguments[0];
        EnhanceObjectCache cache = (EnhanceObjectCache)objInst.getSkyWalkingDynamicField();
        allArguments[0] = (response, connection) -> {
            Publisher publisher = (Publisher)finalReceiver.apply(response, connection);
            if (cache == null) {
                return publisher;
            }
            if (cache.getSpan() != null) {
                if (response.status().code() >= HttpResponseStatus.BAD_REQUEST.code()) {
                    cache.getSpan().errorOccurred();
                }
                Tags.STATUS_CODE.set(cache.getSpan(), String.valueOf(response.status().code()));
                cache.getSpan().asyncFinish();
            }
            if (cache.getSpan1() != null) {
                cache.getSpan1().asyncFinish();
            }
            return publisher;
        };
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

