/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.customize.interceptor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.util.CustomizeExpression;
import org.apache.skywalking.apm.plugin.customize.conf.CustomizeConfiguration;
import org.apache.skywalking.apm.plugin.customize.conf.MethodConfiguration;

class BaseInterceptorMethods {
    BaseInterceptorMethods() {
    }

    void beforeMethod(Method method, Object[] allArguments) {
        Map<String, Object> configuration = CustomizeConfiguration.INSTANCE.getConfiguration(method);
        String operationName = MethodConfiguration.getOperationName(configuration);
        Map context = CustomizeExpression.evaluationContext((Object[])allArguments);
        if (context == null || context.isEmpty()) {
            ContextManager.createLocalSpan((String)operationName);
        } else {
            Map<String, String> tags = MethodConfiguration.getTags(configuration);
            HashMap spanTags = new HashMap();
            Map<String, String> logs = MethodConfiguration.getLogs(configuration);
            HashMap spanLogs = new HashMap();
            List<String> operationNameSuffixes = MethodConfiguration.getOperationNameSuffixes(configuration);
            StringBuilder operationNameSuffix = new StringBuilder();
            if (operationNameSuffixes != null && !operationNameSuffixes.isEmpty()) {
                for (String string : operationNameSuffixes) {
                    operationNameSuffix.append("/");
                    operationNameSuffix.append(CustomizeExpression.parseExpression((String)string, (Map)context));
                }
            }
            if (tags != null && !tags.isEmpty()) {
                for (Map.Entry entry : tags.entrySet()) {
                    spanTags.put(entry.getKey(), CustomizeExpression.parseExpression((String)((String)entry.getValue()), (Map)context));
                }
            }
            if (logs != null && !logs.isEmpty()) {
                for (Map.Entry entry : logs.entrySet()) {
                    String expression = logs.get(entry.getKey());
                    spanLogs.put(entry.getKey(), CustomizeExpression.parseExpression((String)expression, (Map)context));
                }
            }
            operationName = operationNameSuffix.insert(0, operationName).toString();
            AbstractSpan span = ContextManager.createLocalSpan((String)operationName);
            if (!spanTags.isEmpty()) {
                for (Map.Entry tag : spanTags.entrySet()) {
                    span.tag(Tags.ofKey((String)((String)tag.getKey())), (String)tag.getValue());
                }
            }
            if (!spanLogs.isEmpty()) {
                span.log(System.currentTimeMillis(), spanLogs);
            }
        }
    }

    void afterMethod(Method method) {
        ContextManager.stopSpan();
    }

    void handleMethodException(Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }
}

