package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;

/**
 * <p>
 * 
 * </p>
 *
 * @author linfeng.yang
 * @since 2021-11-24
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@Document("crf")
public class Crf extends AbstractAuditingEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    private String name;

    private String description;

    private Long sourceId;

    @Field("question_json")
    private String questionJson;

    @Field("crf_top_id")
    private Long crfTopId;
}
