package com.luca.pilot.entity;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Data
@Accessors(chain = true)
@Document("user_archive")
public class UserArchive {

    @Id
    private String id;
    /**
     * 名字
     */
    private String name;

    /**
     * 手机号
     */
    private String phoneNo;

    /**
     * 男|女
     */
    private String gender;

    /**
     * YYYY-MM-DD格式
     */
    private String birthday;

    /**
     * 身份证后四位
     */
    private String idCardLastFour;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 地址
     */
    private String address;

    /**
     * 学历
     */
    private String education;

    /**
     * 职业（退休前）
     */
    private String job;

    /**
     * 婚姻状况
     */
    private String maritalStatus;

    /**
     * 居住状态
     */
    private String dwellStatus;

    /**
     * 身高
     */
    private String height;

    /**
     * 体重
     */
    private String weight;

    /**
     * 是否喜欢听音乐
     */
    private String likeMusic;

    /**
     * 每周听音乐时长
     */
    private String weekMusciDuration;

    /**
     * 多久入睡
     */
    private String fallAsleep;

    /**
     * 睡眠几小时
     */
    private String sleepTime;

    /**
     * 影响睡眠情况
     */
    private String sleepAffect;

    /**
     * 是否药物助眠
     */
    private String drugHelpSleep;

    /**
     * 是否听不清影响生活
     */
    private String hearingAffectLife;

    /**
     * 是否患有糖尿病
     */
    private String diabetes;
    /**
     * 是否患有高血压
     */
    private String hypertension;
    /**
     * 是否饮酒
     */
    private String drink;
    /**
     * 是否吸烟
     */
    private String smoke;

    /**
     * 规则md5
     */
    private String schemaMd5;

    /**
     * 民族
     */
    private String nation;

    /**
     * 既往病史
     */
    private String pastMedicalHistory;

    /**
     * 随机数
     */
    private String randomizationId;
    /**
     * 过敏史
     */
    private String allergyHistory;

    private String nlfh;//',"健康志愿者，年龄18至75岁（包含边界值），男女不限"
    private String brqs;//',"能够本人签署知情同意书"
    private String yypd;//',"愿意在研究期间佩戴手环收集数据设备"
    private String yytgdz;//',"愿意提供有效的联系地址，以接收研究设备"
    private String ywf;//',"家中需具备Wi-Fi网络连接，网络速度100 Mbps及以上"
    private String yysysj;//',"愿意使用配备数据套餐的手机，并采用合适的数据连接方式传输研究所收集的数据"
    private String ysjxtbs;//',"有神经系统或精神疾病病史，或认知受损或失去行为能力的受试者"
    private String yhgfxshsb;//',"有很高风险损坏设备或不能长时间佩戴的受试者，如经常游泳者"
    private String gmpf;//',"对可穿戴设备过敏或有皮肤过敏史的受试者"
    private String yzyfx;//',"由于健康状况问题，被评估为有住院风险的受试者"
    private String wsyznsb;//',"既往从未使用过智能设备的受试者"
    private String ssz;//',"在筛选时存在需要治疗的急性或慢性疾病的受试者（包括但不限于免疫缺陷或免疫抑制疾病、恶性肿瘤或皮肤疾病等）"
    private String yywly;//',"有药物滥用或药物依赖病史的受试者"
    private String cyqtsy;//',"目前参与其他药物或医疗设备临床试验的受试者"
    private String zzbr;//',"目前正在哺乳的女性"
    private String yjzbsh;//',"研究者认为受试者存在不适合参与试验的其他原因"
    private String wcglx;//',"受试者在签署知情同意时或整个研究期间，无出国旅行计划"

    private String screeningNum; // 筛选号
    private String addressHome; // 家庭住址

    // ------------------ 患者档案固定数据 -------------------
    /**
     * 患者编号 subjectId
     */
    private String subjectId;

    /**
     * 0禁用  1启用(默认)
     */
    private Integer enable = 1;

    /**
     * 是否封存 0否 1是
     */
    private Integer isArchive = 0;

    /**
     * 创建时间
     */
    private String createAt;

    /**
     * 创建人
     */
    private String createBy;

    /**
     * 文件url
     */
    private String fileUrl;
}
