package com.luca.pilot.bizEnum;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum TableEnum {

    armOutstretched("armOutstretched", "clinical_trials_arm_outstretched"),
    bodyPosturalTremorMiddle("bodyPosturalTremorMiddle", "clinical_trials_body_postural_tremor_middle"),
    bodyPosturalTremorMiddleBlind("bodyPosturalTremorMiddleBlind", "clinical_trials_body_postural_tremor_middle_blind"),
    seatedSteppingLeft("seatedSteppingLeft", "clinical_trials_foot_tap_seated_left"),
    seatedSteppingRight("seatedSteppingRight", "clinical_trials_foot_tap_seated_right"),
    gaitStability("gaitStability", "clinical_trials_gait_and_balance"),
    gaitUTurn("gaitUTurn", "clinical_trials_gait_u_turn"),
    handKineticTremorLeft("handKineticTremorLeft", "clinical_trials_hand_kinetic_tremor_left"),
    handKineticTremorRight("handKineticTremorRight", "clinical_trials_hand_kinetic_tremor_right"),
    handPosturalTremorLeft("handPosturalTremorLeft", "clinical_trials_hand_postural_tremor_left"),
    handPosturalTremorRight("handPosturalTremorRight", "clinical_trials_hand_postural_tremor_right"),
    handRestTremorLeft("handRestTremorLeft", "clinical_trials_hand_rest_tremor_left"),
    handRestTremorRight("handRestTremorRight", "clinical_trials_hand_rest_tremor_right"),
    indexFingerTappingTwoTargetLeft("indexFingerTappingTwoTargetLeft", "clinical_trials_index_finger_tap_two_target_left"),
    indexFingerTappingTwoTargetRight("indexFingerTappingTwoTargetRight", "clinical_trials_index_finger_tap_two_target_right"),
    indexFingerTappingOneTargetLeft("indexFingerTappingOneTargetLeft", "clinical_trials_index_finger_tapping_one_target_left"),
    indexFingerTappingOneTargetRight("indexFingerTappingOneTargetRight", "clinical_trials_index_finger_tapping_one_target_right"),
    legRestTremorLeft("legRestTremorLeft", "clinical_trials_leg_rest_tremor_left"),
    legRestTremorRight("legRestTremorRight", "clinical_trials_leg_rest_tremor_right"),
    mci("mci", "clinical_trials_mci"),
    handPronationSupinationLeft("handPronationSupinationLeft", "clinical_trials_palm_flip_left"),
    handPronationSupinationRight("handPronationSupinationRight", "clinical_trials_palm_flip_right"),
    sitToStand30s("sitToStand30s", "clinical_trials_sit_to_stand_by_thirty"),
    tremor("tremor", "clinical_trials_tremor_detection"),
    twoFingerTappingTwoTargetLeft("twoFingerTappingTwoTargetLeft", "clinical_trials_two_finger_tapping_two_target_left"),
    twoFingerTappingTwoTargetRight("twoFingerTappingTwoTargetRight", "clinical_trials_two_finger_tapping_two_target_right"),
    vision("vision", "clinical_trials_vision"),
    visionColorBlindnessType("visionColorBlindnessType", "clinical_trials_vision_color_blindness_type"),
    visionContrastSensitivity("visionContrastSensitivity", "clinical_trials_vision_contrast_sensitivity"),
    visionEsdmt("visionEsdmt", "clinical_trials_vision_esdmt"),
    visionVibrationSensitivity("visionVibrationSensitivity", "clinical_trials_vision_vibration_sensitivity"),
    ;

    private final String moudleItemType;
    private final String tableName;

    public static String getTableNameByType(String type) {
        for (TableEnum value : TableEnum.values()) {
            if (value.getMoudleItemType().equals(type)) {
                return value.getTableName();
            }
        }
        return null;
    }
}
