package com.luca.pilot.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

/**
 * @author Wong
 * @date 2024/1/6 14:17
 */
@Slf4j
@Configuration
//@EnableMongoRepositories(basePackages = "com.luca.pilot.entity")
public class MongoBaseTemplateConfig {

    @Value("${spring.data.base-mongodb.uri}")
    private String uri;

    @Primary
    @Bean(name = "mongoTemplate")
    public MongoTemplate mongoBaseTemplate() {
        log.info("-----------------------Backend Init MongoBaseTemplate Success -----------------------------------");
        return new MongoTemplate(mongoBaseFactory());
    }

    @Bean
    @Primary
    public MongoDatabaseFactory mongoBaseFactory() {
        SimpleMongoClientDatabaseFactory simpleMongoClientDbFactory = new SimpleMongoClientDatabaseFactory(uri);
        return simpleMongoClientDbFactory;
    }

}
