package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author Wong
 * @since 2023-11-30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@Document("clinical_trials_event")
public class ClinicalTrialsEvent extends AbstractAuditingEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 项目Code
     */
    private String projectCode;

    /**
     * uaa用户id
     */
    private Long uaaUserId;

    /**
     * DBM-事件id
     */
    @Field("event_id")
    private Long eventId;

    /**
     * 计划任务id
     */
    @Field("plan_details_id")
    private Long planDetailsId;

    /**
     * 关联模块分类(例如: DIGITAL_MEDICAL/COLLECT_FLOW)
     */
    @Field("relation_type")
    private String relationType;

    /**
     * 关联模块id
     */
    @Field("relation_id")
    private Long relationId;

    /**
     * 模块项类型 (例如: sitToStand/collect_module)
     */
    @Field("module_item_type")
    private String moduleItemType;

    /**
     * 科研采集 - 采集类型
     */
    @Field("collect_type")
    private String collectType;

    /**
     * 科研采集 - 本地算法
     */
    private String localAlgorithm;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 完成时间
     */
    private String finishTime;


}
