package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.time.LocalDateTime;

/**
 * <p>
 * 患者任务计划详情表
 * </p>
 *
 * @author Lt
 * @since 2021-11-08
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@Document(collection="plan_task_details")
public class PlanTaskDetails extends AbstractAuditingEntity {

    /**
     * id
     */
    private Long id;

    /**
     * 计划code  //todo 临时字段
     */
    @Field("schedule_task_code")
    private String scheduleTaskCode;

    /**
     * 租户id
     */
    @Field("tenant_id")
    private Long tenantId;

    /**
     * 项目id
     */
    @Field("project_id")
    private Long projectId;

    /**
     * 患者任务计划id
     */
    @Field("plan_task_id")
    private Long planTaskId;

    /**
     * 患者code
     */
    @Field("patient_code")
    private String patientCode;

    /**
     * 计划开始日期
     */
    @Field("start_date")
    private String startDate;

    /**
     * 计划结束日期
     */
    @Field("end_date")
    private String endDate;

    /**
     * 计划完成状态(0:未完成 1:已完成)
     */
    @Field("complete_status")
    private Integer completeStatus;

    /**
     * 计划完成时间
     */
    @Field("complete_time")
    private String completeTime;

    /**
     * 命中条件(若是循环周内几次1111100:标识 周一到周五做,周六周天不做; 其它类型任务:1)
     */
    private String hit;

    /**
     * 完成顺序
     */
    @Field("complete_order")
    private Integer completeOrder;

    /**
     * 0 禁用 1 启用
     */
    private Integer enabled;

}
