package com.luca.pilot.entity;


import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

/**
 * <p>
 * 患者任务计划与模块关联表
 * </p>
 *
 * @author Lt
 * @since 2021-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Document(collection="plan_task_module_relate")
public class PlanTaskModuleRelate extends AbstractAuditingEntity {

    /**
     * id
     */
    private Long id;

    /**
     * 租户id
     */
    @Field("tenant_id")
    private Long tenantId;

    /**
     * 关联model类型
     */
    @Field("relation_type")
    private String relationType;

    /**
     * 关联id
     */
    @Field("relation_id")
    private Long relationId;

    /**
     * 患者任务计划id
     */
    @Field("plan_task_id")
    private Long planTaskId;

}
