package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author linfeng.yang
 * @since 2021-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Document("questionnaire_answer")
public class QuestionnaireAnswer extends AbstractAuditingEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @Field("questionnaire_id")
    private Long questionnaireId;

    @Field("questionnaire_name")
    private String questionnaireName;

    @Field("question_id")
    private Long questionId;

    @Field("question_name")
    private String questionName;

    private String type;

    private Long tenantId;


    /**
     * 患者任务详情id
     */
    @Field("plan_task_details_id")
    private Long planTaskDetailsId;

    /**
     * 睡眠问卷睡眠类型
     */
    private Integer sleepType;

    /**
     * site Id
     */
    private String siteId;
    /**
     * 主记录id
     */
    @Field("record_id")
    private Long recordId;

//    @ApiModelProperty(value = "关联schedule")
//    private String scheduleTaskCode;

}
