package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author linfeng.yang
 * @since 2021-10-21
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@Document("questionnaire_answer_record")
public class QuestionnaireAnswerRecord extends AbstractAuditingEntity implements Serializable{

    private static final long serialVersionUID = 1L;

    private Long id;

    @Field("top_id")
    private Long topId;

    @Field("project_code")
    private String projectCode;

    @Field("site_id")
    private String siteId;

    @Field("patient_code")
    private String patientCode;

    /**
     * 患者任务详情id
     */
    @Field("plan_task_details_id")
    private Long planTaskDetailsId;

    /**
     * 计划完成时间
     */
    @Field("complete_time")
    private String completeTime;



}
