package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;

import java.math.BigDecimal;

/**
 * @author linfeng.yang
 * @date 2021/8/03 下午14:40
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@Document("scale_module_details")
public class ScaleModuleDetailsEntity extends AbstractAuditingEntity {

    private Long id;
    private String code;
    private String name;
    private String description;
    private String ruleDescription;
    private Integer status;     //0:未发布 1:已发布 2:已下架
    private String tags;
    private String scaleImg;
    private String url;
    private String abbreviation;
    private BigDecimal scaleScore;
    private String ruleResult;
    private String ruleContent;
}
