package com.luca.pilot.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

/**
 * @author linfeng.yang
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@Document(collection="user_archive_mapping")
public class UserArchiveMapping extends AbstractAuditingEntity {
    private Long id;
    @Field("project_code")
    private String projectCode;

    @Field("site_id")
    private Long siteId;

    @Field("uaa_user_id")
    private Long uaaUserId;

    @Field("patient_code")
    private String patientCode;

    @Field("user_archive_id")
    private String userArchiveId;

}
